*** rt-ustar.do
*** v1.2
***
*** Creates u-star forecasts from real-time data. Outputs ur_NNN, where NNN is
***   the date of the first forecast for the UR (i.e., the unemployment rate is known through
***   month NNN-1). NNN is the Stata date code for months, where 192 = 1976m1.
***
clear all
set more off
set type double
set matsize 1000

global path = "$HOME/research/ssur"

tempfile ssur_data
insheet using $path/bpea/ssur_data_bpea.csv, comma clear
gen int mdate = tm(1951m1)+_n-1
order mdate
drop v1
unab foo: *
foreach bar of local foo {
  qui destring `bar', replace force
}
tsset mdate, m
keep mdate hwi uic
save `ssur_data'

use $path/data/rtdata/rt-E.dta, clear
merge 1:1 mdate using $path/data/rtdata/rt-U.dta, nogen
merge 1:1 mdate using $path/data/rtdata/rt-U_s.dta, nogen
merge 1:1 mdate using `ssur_data', nogen

keep if mdate>=tm(1951m1)

cap erase fhist-ustar.dta

unab rellist: E_*
local rdatelist: subinstr local rellist "E_" "", all
local i = 1
preserve
foreach rdate of local rdatelist {
  if `rdate'>=106 {
    noi disp "$S_DATE $S_TIME " %tm `rdate'
    restore, preserve
    gen E = E_`rdate'
    gen U = U_`rdate'
    gen U_s = U_s_`rdate'
    sum mdate if E_`rdate'!=.
    outsheet mdate E U U_s hwi uic if mdate<=r(max) using foo.csv, comma replace nonames
    !echo "E U U_S HWI UIC" > input.csv
    !cat foo.csv >> input.csv
    !rats rt-ustar.prg rt-ustar-`rdate'.out
    insheet using output.csv, comma clear
    gen int mdate=tm(1951m1)+_n-1
    drop v1
    order mdate
    keep mdate ur_ustar
    rename ur_ustar ur_ustar_`rdate'
    if `i'>1 {
      merge 1:1 mdate using fhist-ustar.dta, nogen
    }
    compress
    save fhist-ustar.dta, replace
    local i=`++i'
  }
}

use fhist-ustar.dta, replace
reshape long ur_ustar_, i(mdate) j(fcdate)
rename ur_ustar_ ur_ustar
order fcdate mdate
sort fcdate mdate
format %tm *date
drop if ur_ustar==.
compress
save rt-ustar.dta, replace

* clean up
!gzip -9 fhist-ustar.dta
erase foo.csv
erase input.csv
erase output.csv
!tar czf ustar-rt-logs.tgz rt-ustar-*.out
!rm rt-ustar-*.out

if "$S_CONSOLE"=="console" exit, STATA clear
